<?php

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Handle frontend styles for Finmo payments
 */
class Finmo_Frontend_Styles
{
    private $gateway_id;

    public function __construct($gateway_id)
    {
        $this->gateway_id = $gateway_id;
    }

    /**
     * Enqueue CSS + optional JS for Finmo checkout UI
     */
    public function enqueue_frontend_styles()
    {
        try {
            $css = '
            .payment_box.payment_method_finmo_payments {
                font-weight: 500;
                position: relative;
                box-sizing: border-box;
                width: 100%;
                padding: 0.8em 0.5em !important;
                margin: 0 !important;
                font-size: .92em;
                border-radius: 2px;
                line-height: 1.5;
                background-color: #dcd7e2;
                color: #515151;
             }

            .finmo-payment-method-display {
                display: flex;
                align-items: center;
                gap: 15px;
                padding: 10px 0;
            }
            
            .finmo-company-info {
                display: flex;
                align-items: center;
                gap: 10px;
            }
            
            .finmo-company-name {
                font-weight: 600;
                font-size: 16px;
                color: #333;
            }
            
            .finmo-logo {
                height: 20px;
                width: auto;
                vertical-align: middle;
            }
            
            .finmo-divider {
                width: 1px;
                height: 40px;
                background-color: #ddd;
                margin: 0 5px;
            }
            
            .finmo-payment-methods {
                display: flex;
                flex-direction: column;
                gap: 1px;
                align-items: flex-start;
            }
            
            .finmo-methods-row {
                display: flex;
                gap: 15px;
                align-items: center;
            }
            
            .finmo-payment-methods span {
                font-size: 14px;
                color: #666;
                font-weight: 500;
            }
            
            .finmo-description {
                margin-top: 8px;
                padding-left: 0;
            }
            
           .payment_box.payment_method_finmo_payments {
                font-size: 17px;
                color: #666;
                font-weight: 500;
            }
            
            label[for="payment_method_' . esc_attr($this->gateway_id) . '"] img {
                height: 30px !important;
                max-height: none !important;
                width: auto !important;
                display: inline-block;
                vertical-align: middle;
            }';
            
            wp_register_style('finmo-payments-frontend', false);
            wp_enqueue_style('finmo-payments-frontend');
            wp_add_inline_style('finmo-payments-frontend', $css);

            /**
             * You can add `assets/js/finmo-frontend.js` for dynamic
             * show/hide or extra logging.
             */
            $js_path = FINMO_PAYMENTS_PLUGIN_PATH . 'assets/js/finmo-frontend-styles.js';
            if (file_exists($js_path)) {
                wp_enqueue_script(
                    'finmo-frontend-js',
                    FINMO_PAYMENTS_PLUGIN_URL . 'assets/js/finmo-frontend-styles.js',
                    ['jquery'],
                    FINMO_PAYMENTS_VERSION,
                    true
                );
            }
        } catch (Exception $e) {
            error_log('[Finmo Frontend Styles Exception] ' . $e->getMessage());
        }
    }
}